
# NOTE: based on the data, run the codes from data processing for table 11 or data processing for table 12 or 13 #

########## data processing for table 11 ##########

id=dat$obs
dat=dat[-c(ncol(dat))]

##### data for semiparametric estimation #####

# generate a country-characteristic indicator variable and remove irrelevant variables #

I=ifelse(dat[c(8)]>0,1,0)
DD=dat[-c(4,7,8)]
DD$indicator=I

# rename variables #

D=as.matrix(DD)
n1=ncol(D)-1
xname=paste("x",1:n1,sep="")
colnames(D)=c("y",xname)
D=data.frame(D)

##### data for parametric estimation #####

# place variables in a specific order, i.e., dependent variable, endogenous variables, instrumental variables, etc. #

EE=cbind(dat[c(1,2,4,3,7,8,5,6)],dat[-c(1,2,3,4,5,6,7,8)])

# rename variables #

E=as.matrix(EE)
n1=ncol(E)-1
xname=paste("x",1:n1,sep="")
colnames(E)=c("y",xname)
E=data.frame(E)

####################################################################################################

########## data processing for table 12 or 13 ##########

id=dat$obs
dat=dat[-c(ncol(dat))]

##### data for semiparametric estimation #####

# generate a country-characteristic indicator variable and remove irrelevant variables #

I=ifelse(dat[c(6)]>0,1,0)
DD=dat[-c(4,5,6)]
DD$indicator=I

# rename variables #

D=as.matrix(DD)
n1=ncol(D)-1
xname=paste("x",1:n1,sep="")
colnames(D)=c("y",xname)
D=data.frame(D)

##### data for parametric estimation #####

# place variables in a specific order, i.e., dependent variable, endogenous variables, instrumental variables, etc. #

EE=cbind(dat[c(1,2,4,3)],dat[-c(1,2,3,4)])

# rename variables #

E=as.matrix(EE)
n1=ncol(E)-1
xname=paste("x",1:n1,sep="")
colnames(E)=c("y",xname)
E=data.frame(E)
